#www.lasseclausen.com/lab/
#Use at your own risk
#Last-Modified: 02/02/2018
"""
Name-US:Import Adobe Color CC Swatches
Description-US:[DEFAULT] Import Swatches + Reference Cubes|[CTRL] Opens https://color.adobe.com|[SHIFT] Import Swatches only
"""
import c4d
from c4d import gui
import os
import urlparse

DEBUG = False
PRE_R18_MESSAGE = True

def GetModifiers():
    bc = c4d.BaseContainer()
    ctrl, shift, alt = False, False, False
    if c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD, c4d.BFM_INPUT_CHANNEL, bc):
        if bc[c4d.BFM_INPUT_QUALIFIER] & c4d.QSHIFT:
            shift = True
        if bc[c4d.BFM_INPUT_QUALIFIER] & c4d.QCTRL:
            ctrl = True
        if bc[c4d.BFM_INPUT_QUALIFIER] & c4d.QALT:
            alt = True
    return ctrl, shift, alt

def RgbToVector(x, y, z):
    return c4d.Vector(float(x), float(y), float(z))

def Color_Dict():
    url = None
    if c4d.GetClipboardType() == c4d.CLIPBOARDTYPE_STRING:
        url = c4d.GetStringFromClipboard()
        if not url.startswith("https://color.adobe.com/"):
            return

    if url is None: return

    url_dict =  urlparse.parse_qs(url)
    if url_dict == {}: return
    if len(url_dict) <= 1: return
    
    if DEBUG:
        print url_dict
        print url_dict['name']
        print url_dict['rule']
        print url_dict['mode']
    
    clr_name = url_dict['name'][0]
    
    rgb_liste = url_dict['rgbvalues']
    swatch_order = url_dict['swatchOrder']
    
    rgb_liste = [x.split(',') for x in rgb_liste][0]
    swatch_order = [x.split(',') for x in swatch_order][0]
    
    if len(rgb_liste) == 15:
        clr1 = RgbToVector(rgb_liste[0], rgb_liste[1], rgb_liste[2]) 
        clr2 = RgbToVector(rgb_liste[3], rgb_liste[4], rgb_liste[5]) 
        clr3 = RgbToVector(rgb_liste[6], rgb_liste[7], rgb_liste[8])
        clr4 = RgbToVector(rgb_liste[9], rgb_liste[10], rgb_liste[11])
        clr5 = RgbToVector(rgb_liste[12], rgb_liste[13], rgb_liste[14])

    five_clrs = [clr1, clr2, clr3, clr4, clr5]

    return clr_name, swatch_order, five_clrs

def InsertSwatches(doc, group_name, swatch_order, five_clrs):
    colors=[]
    
    for index in swatch_order:
        colors.append(five_clrs[int(index)])
        
    swatch_data = c4d.modules.colorchooser.ColorSwatchData(doc)
    if swatch_data is None:
        return

    group = swatch_data.AddGroup(group_name, False)
    if group is not None:
        group.AddColors(colors)
        group.SetName(group_name)
        swatch_data.SetGroupAtIndex(swatch_data.GetGroupCount() - 1, group)
        
    swatch_data.Save(doc)

def InsertObjects(clr_name, swatch_order, five_clrs):        
    null = c4d.BaseObject(c4d.Onull)
    null.SetName(clr_name)
    doc.InsertObject(null)
    doc.AddUndo(c4d.UNDOTYPE_NEW, null)
    for i, index in enumerate(swatch_order):
        cube = c4d.BaseObject(c4d.Ocube)
        cube[c4d.ID_BASEOBJECT_USECOLOR] = 2
        cube[c4d.PRIM_CUBE_DOFILLET] = True
        cube[c4d.PRIM_CUBE_FRAD] = 5.0
        cube[c4d.ID_BASEOBJECT_COLOR] = five_clrs[int(index)]
        cube.SetName(str(index))
        cube[c4d.ID_BASEOBJECT_REL_POSITION] = c4d.Vector(i*200, 0,0)
        doc.InsertObject(cube)
        cube.InsertUnder(null)
        doc.AddUndo(c4d.UNDOTYPE_NEW, cube)

def OpenWebsite(url):
    import webbrowser
    webbrowser.open_new_tab(url)

def main():
    ctrl, shift, alt = GetModifiers()
    
    if ctrl:
        OpenWebsite('https://color.adobe.com/create/color-wheel/')
        return

    if Color_Dict() is None: return
    
    clr_name, swatch_order, five_clrs = Color_Dict()
    
    doc.StartUndo()
    #PRE R18 VERSION ( INSERT ONLY OBJECTS )
    if c4d.GetC4DVersion() <= 18011:
        if PRE_R18_MESSAGE:
            gui.MessageDialog("I'm sorry, Color-Swatches haven't been introduced in your C4D-Version.\nYou need at least C4D R18! I'll just add some Cubes with Colors... Okay!?")
        InsertObjects(clr_name, swatch_order, five_clrs)
        doc.EndUndo()
        c4d.EventAdd()
        return

    #SHIFT-CLICK: ONLY ADD SWATCHES
    if shift:
        InsertSwatches(doc, clr_name, swatch_order, five_clrs)
        doc.EndUndo()
        c4d.EventAdd()
        return
    
    #DEFAULT-CLICK: REFERENCE CUBES + SWATCHES
    InsertObjects(clr_name, swatch_order, five_clrs)
    InsertSwatches(doc, clr_name, swatch_order, five_clrs)

    doc.EndUndo()
    c4d.EventAdd()
      

if __name__=='__main__':
    main()
