#www.lasseclausen.com/lab/
#Use at your own risk
#Last-Modified: 30.11.2017
"""
Name-US:PickFocusDistance
Description-US:Create a Shortcut, for Example: [ < ]
"""
import c4d
from c4d import gui

def GetActiveCam():
    bd=doc.GetActiveBaseDraw()
    sel=doc.GetActiveObject()
    
    if sel and sel.GetType()!=c4d.Ocamera:
        #print "1"
        cam=bd.GetSceneCamera(doc)
        doc.SetSelection(cam, c4d.SELECTION_NEW)
        bd.SetSceneCamera(cam)
        return cam
    
    if sel and sel.GetType()==c4d.Ocamera:
        #print "2"
        cam=sel
        return cam
    
    #print "3"
    cam=bd.GetSceneCamera(doc)
    doc.SetSelection(cam, c4d.SELECTION_NEW)
    bd.SetSceneCamera(cam)
    return cam

 
def click():
    #Windows-Only / Direct Click for Shortcut
    if c4d.GeGetCurrentOS()==1:
        import ctypes
        ctypes.windll.user32.mouse_event(0x2, 0,0,0,0)    # Mouse LClick Down, relative coords, dx=0, dy=0
        ctypes.windll.user32.mouse_event(0x4, 0,0,0,0)    # Mouse LClick Up, relative coords, dx=0, dy=0
    else: return
 
def main():
    cam=GetActiveCam()
    if cam.GetMain() is None:
        gui.MessageDialog("Please select a Camera, or at least look through one..! =P")
    
    gui.SetMousePointer(c4d.MOUSE_CROSS) 
    c4d.CallButton(cam, c4d.CAMERAOBJECT_TARGETDISTANCE_PICK)
    click()
    gui.SetMousePointer(c4d.MOUSE_NORMAL)
    
if __name__=='__main__':
    main()