#www.lasselauch.com/lab/
#Use at your own risk
#Last-Modified: 20/11/2018
"""
Name-US:Toggle_Deformer/Effector/Forces/Fields
Description-US:Toggles Deformer/Mograph-Effector/Forces & Fields Viewport-Visibility. [CTRL-Click] for Reset. [SHIFT-Click] for Solo.
"""
import c4d

def GetAllObjects(op, liste):
    liste.append(op)
    for child in op.GetChildren():
        GetAllObjects(child, liste)

def VisibilityControl(obj, bc):
    #DEFAULT: TOGGLE VIEWPORT VISIBILITY
    doc.AddUndo(c4d.UNDOTYPE_CHANGE, obj)
    obj.ChangeNBit(c4d.NBIT_EHIDE, c4d.NBITCONTROL_TOGGLE)

    #CTRL-Click: CLEAR TOGGLE VIEWPORT VISIBILITY
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD, c4d.BFM_INPUT_CHANNEL, bc)
    if bc[c4d.BFM_INPUT_QUALIFIER]==2:
        obj.ChangeNBit(c4d.NBIT_EHIDE, c4d.NBITCONTROL_CLEAR)

    #CTRL-SHIFT-Click: CLEAR TOGGLE VIEWPORT VISIBILITY
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD, c4d.BFM_INPUT_CHANNEL, bc)
    if bc[c4d.BFM_INPUT_QUALIFIER]==1:
        obj.ChangeNBit(c4d.NBIT_EHIDE, c4d.NBITCONTROL_SET)

def main():
    bc = c4d.BaseContainer()
    sel = doc.GetActiveObjects(True)

    allobjs = []
    for obj in doc.GetObjects():
        GetAllObjects(obj, allobjs)

    doc.StartUndo()
    for obj in allobjs:
        #R20 Compatibility
        if c4d.GetC4DVersion() >= 20000:
            if obj.GetInfo() & c4d.OBJECT_FIELDOBJECT and obj not in sel:
                VisibilityControl(obj, bc)
        if obj.GetInfo() & c4d.OBJECT_MODIFIER | obj.GetInfo() & c4d.OBJECT_PARTICLEMODIFIER and obj not in sel:
            VisibilityControl(obj, bc)

    c4d.EventAdd()
    doc.EndUndo()

if __name__=='__main__':
    main()