#www.lasseclausen.com/lab/
#Use at your own risk
#Last-Modified: 11/09/2016
"""
Name-US:Hide unselected Deformers/Effectors/Forces
Description-US:Hide unselected Deformers, Mograph-Effectors and Forces. [CTRL-Click] to set them to Default.
"""
import c4d

def BrowseObjs(obj, dlist, elist, flist, children):
    deformerlist=[c4d.Obend,c4d.Obulge,c4d.Oshear,c4d.Otaper,c4d.Otwist,c4d.Offd,1024543,1021280,c4d.Omelt,c4d.Oexplosion,c4d.Oformula,c4d.Oexplosionfx,c4d.Oshatter,1024542,1021284,1019768,1019774,c4d.Ospherify,1024552,c4d.Owrap,1008982,1008796,1019221,1024476,1024544,1018685,5149,c4d.Opolyreduction,1024529,431000028]
    effectorlist=[1019351,1021337,440000051,1019234,1018883,1018775,1025800,1018643,1018561,1018882,1018774,1018881,1018889,1018935,1021287,440000219,440000234]
    forceslist=[5110,5111,5112,5113,5114,5115,5124,5119,180000012,180000103,180000010,180000011]
    
    if not obj: return
    
    for x in deformerlist:
        if obj.GetType()==x:
            dlist.append(obj)

    for x in effectorlist:
        if obj.GetType()==x:
            elist.append(obj)

    for x in forceslist:
        if obj.GetType()==x:
            flist.append(obj)


    BrowseObjs(obj.GetNext(), dlist, elist, flist, children)
    if children:
      BrowseObjs(obj.GetDown(), dlist, elist, flist, children)

def VisibilityOff(obj):
    obj[c4d.ID_BASEOBJECT_VISIBILITY_EDITOR]=1
    obj[c4d.ID_BASEOBJECT_VISIBILITY_RENDER]=1

def VisibilityOn(obj):
    obj[c4d.ID_BASEOBJECT_VISIBILITY_EDITOR]=0
    obj[c4d.ID_BASEOBJECT_VISIBILITY_RENDER]=0

def VisibilityDefault(obj):
    obj[c4d.ID_BASEOBJECT_VISIBILITY_EDITOR]=2
    obj[c4d.ID_BASEOBJECT_VISIBILITY_RENDER]=2

def main():
    bc=c4d.BaseContainer()
    sel=doc.GetActiveObjects(c4d.GETACTIVEOBJECTFLAGS_SELECTIONORDER)
    
    dlist=[]
    elist=[]
    flist=[]
    
    first=doc.GetFirstObject()
    BrowseObjs(first, dlist, elist, flist, True)

    doc.StartUndo()
    
    #Hide Deformers
    for x in dlist:
        doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
        VisibilityOff(x)
    
    #Hide Effectors
    for x in elist:
        doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
        VisibilityOff(x)    
    #Hide Forces
    for x in flist:
        doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
        VisibilityOff(x)
            
    #Selection to Default
    for x in sel:
        doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
        VisibilityOn(x)
        
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD, c4d.BFM_INPUT_CHANNEL, bc)
    if bc[c4d.BFM_INPUT_QUALIFIER]==2: #CTRL-Click
        #Set Everything back to Default
        for x in dlist:
            doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
            VisibilityDefault(x)
            
        for x in elist:
            doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
            VisibilityDefault(x)
                    
        for x in flist:
            doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
            VisibilityDefault(x)
                        
    doc.EndUndo()
    c4d.EventAdd()
    
if __name__=='__main__':
    main()