#www.lasseclausen.com/lab
#Use at your own risk
"""
Name-US:Group Objects / PSR Zero
Description-US:Groups Objects//Keeps PSR at 0//If last selected Object has Layer: Adds new Null to same Layer.
"""

import c4d

def main():
    sel=doc.GetActiveObjects(c4d.GETACTIVEOBJECTFLAGS_SELECTIONORDER)
    if not sel: return
    
    null=c4d.BaseObject(c4d.Onull)

    doc.StartUndo()
    doc.AddUndo(c4d.UNDOTYPE_NEW, null)
    doc.InsertObject(null)
    null.InsertBefore(sel[0])
    
    for x in sel:
        layer=x.GetLayerObject(doc)
        name=str("rt_")+x.GetName()
        doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
        x.InsertUnder(null)
    
    if layer:
        null.SetLayerObject(layer)
    null.SetName(name)
    doc.SetSelection(null, c4d.SELECTION_NEW)
    doc.EndUndo()
    c4d.EventAdd()
    
if __name__=='__main__':
    main()
