#www.lasseclausen.com/lab/
#Use at your own risk
"""
Name-US:Transfer all Objects to last selected v1.5
Description-US:Different Modifier-Keys explained in Script..!

// Default: Transfer all Objects to last selected, as next Object. (Keeps Orignal Scale!)
// SHIFT: Uses the last selected as Parent. (Keeps Orignal Scale!)
// CTRL: Moves selected Objects to last Object and deletes it. (Keeps Orignal Scale!)
// ALT+SHIFT: Uses the last selected Object as Parent. (uses Scale from Last Object!)
// ALT+CTRL: Moves selected Objects to last Object deletes it. (uses Scale from Last Object!)
"""
import c4d

def main():
    bc=c4d.BaseContainer()
    v0=c4d.Vector(0,0,0)
    
    ObjList=doc.GetOrderedActiveObjects()
    if not ObjList: return

    LastObject=ObjList[len(ObjList)-1]
    if not LastObject: return

    doc.StartUndo()
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD, c4d.BFM_INPUT_CHANNEL, bc)
    
    if bc[c4d.BFM_INPUT_QUALIFIER]==0 : #Default
        for x in ObjList:
            if x is not LastObject:
                ml=LastObject.GetMg()
                mx=x.GetMg()
                ml.v1 = ~ml.v1 * mx.v1.GetLength()
                ml.v2 = ~ml.v2 * mx.v2.GetLength()
                ml.v3 = ~ml.v3 * mx.v3.GetLength()
                doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
                x.InsertAfter(LastObject)
                x.SetMg(ml)
                doc.SetSelection(LastObject, c4d.SELECTION_SUB)
                doc.EndUndo()
                c4d.EventAdd()            

    if bc[c4d.BFM_INPUT_QUALIFIER]==1 : #SHIFT-Click
        for x in ObjList:
            if x is not LastObject:
                mg=LastObject.GetMg()
                doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
                x.InsertUnder(LastObject)
                x.SetAbsPos(v0)
                x.SetAbsRot(v0)
                doc.SetSelection(LastObject, c4d.SELECTION_SUB)
                doc.EndUndo()
                c4d.EventAdd()

    if bc[c4d.BFM_INPUT_QUALIFIER]==2 : #CTRL-Click
        for x in ObjList:
            if x is not LastObject:
                ml=LastObject.GetMg()
                mx=x.GetMg()
                ml.v1 = ~ml.v1 * mx.v1.GetLength()
                ml.v2 = ~ml.v2 * mx.v2.GetLength()
                ml.v3 = ~ml.v3 * mx.v3.GetLength()
                doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
                x.InsertAfter(LastObject)
                x.SetMg(ml)
        doc.AddUndo(c4d.UNDOTYPE_DELETE, LastObject)
        LastObject.Remove()
        doc.EndUndo()
        c4d.EventAdd()

    if bc[c4d.BFM_INPUT_QUALIFIER]==5 : #ALT+SHIFT-Click
        for x in ObjList:
            if x is not LastObject:
                mg=LastObject.GetMg()
                doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
                x.InsertUnder(LastObject)
                x.SetMg(mg)
                doc.SetSelection(LastObject, c4d.SELECTION_SUB)
                doc.EndUndo()
                c4d.EventAdd()

    if bc[c4d.BFM_INPUT_QUALIFIER]==6 : #ALT+CTRL-Click
        for x in ObjList:
            if x is not LastObject:
                mg=LastObject.GetMg()
                doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
                x.InsertAfter(LastObject)
                x.SetMg(mg)
        doc.AddUndo(c4d.UNDOTYPE_DELETE, LastObject)
        LastObject.Remove()
        doc.EndUndo()
        c4d.EventAdd()
   
if __name__=='__main__':
    main()