#www.lasseclausen.com
#Use at your own risk
"""
Name-US: A_Simple-Spline [X,Y,Z]
Description-US: DEFAULT: Z-Axis // CTRL: X-Axis // SHIFT: Y-Axis
"""
import c4d

def main():
    
    spline=c4d.BaseObject(c4d.Ospline)
    clr_x=c4d.Vector(0.983, 0.337, 0.337)
    clr_y=c4d.Vector(0.337, 0.983, 0.617)
    clr_z=c4d.Vector(0.337, 0.671, 0.983)
    name_x=name=str("X+_")+spline.GetName()
    name_z=name=str("Z+_")+spline.GetName()
    name_y=name=str("Y+_")+spline.GetName()
    bc=c4d.BaseContainer()
    
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD, c4d.BFM_INPUT_CHANNEL, bc)

    if bc.GetLong(c4d.BFM_INPUT_QUALIFIER) & c4d.QCTRL:
        spline.SetName(name_x)
        doc.InsertObject(spline, checknames=True)
        spline[c4d.ID_BASEOBJECT_USECOLOR]=1
        spline[c4d.ID_BASEOBJECT_COLOR]=(clr_x)
        c4d.PointObject.ResizeObject(spline, 2)
        c4d.PointObject.SetPoint(spline, 1, c4d.Vector(10,0,0))

    elif bc.GetLong(c4d.BFM_INPUT_QUALIFIER) & c4d.QSHIFT:
        spline.SetName(name_y)
        spline[c4d.ID_BASEOBJECT_USECOLOR]=1
        spline[c4d.ID_BASEOBJECT_COLOR]=(clr_y)
        doc.InsertObject(spline, checknames=True)
        c4d.PointObject.ResizeObject(spline, 2)
        c4d.PointObject.SetPoint(spline, 1, c4d.Vector(0,10,0))

    else:
        spline.SetName(name_z)
        spline[c4d.ID_BASEOBJECT_USECOLOR]=1
        spline[c4d.ID_BASEOBJECT_COLOR]=(clr_z)
        doc.InsertObject(spline, checknames=True)
        c4d.PointObject.ResizeObject(spline, 2)
        c4d.PointObject.SetPoint(spline, 1, c4d.Vector(0,0,10))
    
    spline.Message(c4d.MSG_UPDATE)
    c4d.EventAdd()

if __name__=='__main__':
    main()
