#www.lasseclausen.com
#Use at your own risk
"""
Name-US: Toggle Visibility of Selected Objects
Description-US: Without Modifier: All Red, CTRL: Default, SHIFT: All Green, CTRL+SHIFT: Red/Green, ALT+SHIFT:Green/Red
"""
import c4d

def main():
  doc.StartUndo()
  sel=doc.GetSelection()
  bc=c4d.BaseContainer()

  if c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc):
    for x in sel:
        doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
        x[c4d.ID_BASEOBJECT_VISIBILITY_EDITOR]=1
        x[c4d.ID_BASEOBJECT_VISIBILITY_RENDER]=1
    doc.EndUndo
    c4d.EventAdd()
    
    if bc[c4d.BFM_INPUT_QUALIFIER] ==1 : #Shift-Click
      for x in sel:
          doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
          x[c4d.ID_BASEOBJECT_VISIBILITY_EDITOR]=0
          x[c4d.ID_BASEOBJECT_VISIBILITY_RENDER]=0
      doc.EndUndo
      c4d.EventAdd()

    if bc[c4d.BFM_INPUT_QUALIFIER] ==2 : #CTRL-Click
      for x in sel:
          doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
          x[c4d.ID_BASEOBJECT_VISIBILITY_EDITOR]=2
          x[c4d.ID_BASEOBJECT_VISIBILITY_RENDER]=2
      doc.EndUndo
      c4d.EventAdd()
      
    if bc[c4d.BFM_INPUT_QUALIFIER] ==3 : #CTRL+Shift-Click
      for x in sel:
          doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
          x[c4d.ID_BASEOBJECT_VISIBILITY_EDITOR]=1
          x[c4d.ID_BASEOBJECT_VISIBILITY_RENDER]=0
      doc.EndUndo
      c4d.EventAdd()

    if bc[c4d.BFM_INPUT_QUALIFIER] ==5 : #ALT+Shift-Click
      for x in sel:
          doc.AddUndo(c4d.UNDOTYPE_CHANGE, x)
          x[c4d.ID_BASEOBJECT_VISIBILITY_EDITOR]=0
          x[c4d.ID_BASEOBJECT_VISIBILITY_RENDER]=1
      doc.EndUndo
      c4d.EventAdd()

if __name__=='__main__':
    main()